import { View, Dimensions, FlatList, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";

const { width } = Dimensions.get("window");

const RenderItem = ({ item }) => {
    return (
        <View style={styles.itemCont}>
            <SkeletonElement wrapperStyle={styles.skeletonWrapperStyle1} />
            <View style={styles.skeletonElementContainer}>
                <SkeletonElement
                    wrapperStyle={styles.skeletonWrapper(12, 100)}
                />
                <SkeletonElement
                    wrapperStyle={styles.skeletonWrapper(14, 130)}
                />
            </View>
        </View>
    );
};

const ListViewSkeleton = () => {
    return (
        <FlatList
            data={[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]}
            keyExtractor={(_, i) => "key" + i}
            renderItem={({ item }) => <RenderItem item={item} />}
            showsVerticalScrollIndicator={false}
        />
    );
};

export default ListViewSkeleton;

const styles = StyleSheet.create({
    itemCont: {
        marginBottom: dpr(20),
        flexDirection: "row",
        alignContent: "center",
    },
    skeletonElementContainer: {
        flexDirection: "column",
        justifyContent: "center",
        marginLeft: dpr(20),
    },
    skeletonWrapperStyle1: {
        width: width / 2.5 - dpr(30),
        height: width / 2.5 - dpr(30),
    },
    skeletonWrapper: (height, width) => ({
        height: dpr(height),
        width: dpr(width),
    })
});
